<?php $__env->startSection('title', 'CEYLON THARU TRAVELS | PACKAGE INQUIRIES'); ?>
<?php $__env->startSection('content_admin'); ?>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>All Package Inquiries</h1>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Inquiry Management</h3>
                    </div>
                    <div class="card-body">
                        <table id="inquiries-table" class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>User Name</th>
                                    <th>Package</th>
                                    <th>Number of People</th>
                                    <th>Expected Date</th>
                                    <th>Country</th>
                                    <th>Mobile</th>
                                    <th>Email</th>
                                    <th>Special Requests</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($booking->user_name); ?></td>
                                        <td><?php echo e($booking->package->title); ?></td>
                                        <td><?php echo e($booking->num_people); ?></td>
                                        <td><?php echo e($booking->expected_date); ?></td>
                                        <td><?php echo e($booking->country); ?></td>
                                        <td>
                                            <a href="tel:<?php echo e($booking->mobile); ?>"><?php echo e($booking->mobile); ?></a>
                                        </td>
                                        <td>
                                            <a href="mailto:<?php echo e($booking->email); ?>"><?php echo e($booking->email); ?></a>
                                        </td>
                                        <td><?php echo e($booking->special_req ?? 'None'); ?></td>
                                        <td>
                                            <form action="<?php echo e(route('inquiries.destroy', $booking->id)); ?>" method="POST"
                                                style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm"
                                                    onclick="return confirm('Are you sure you want to delete this inquiry?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- DataTables CSS & JS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.5/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.5/js/jquery.dataTables.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#inquiries-table').DataTable({
                responsive: true,
                pageLength: 10,
                order: [
                    [3, 'asc']
                ] // order by Expected Date
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Savi Aby\Desktop\New folder (2)\Tharu_tours_asiri_savi\ceylon_tharu_tours\resources\views/admin/package_inquries.blade.php ENDPATH**/ ?>