<?php $__env->startSection('title', 'CEYLON THARU TRAVELS | EDIT ITINERARY'); ?>

<?php $__env->startSection('content_admin'); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Edit Itinerary for <?php echo e($package->title); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('packages.index')); ?>">Packages</a></li>
                            <li class="breadcrumb-item"><a
                                    href="<?php echo e(route('packages.itineraries', $package->id)); ?>">Itineraries</a></li>
                            <li class="breadcrumb-item active">Edit</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">Edit Itinerary</h3>
                    </div>
                    <form action="<?php echo e(route('packages.itineraries.update', [$package->id, $itinerary->id])); ?>" method="POST"
                        enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="card-body">
                            <div class="form-group">
                                <label for="day_number">Day Number</label>
                                <select name="day_number" id="day_number" class="form-control" required>
                                    <?php for($i = 1; $i <= 10; $i++): ?>
                                        <option value="<?php echo e($i); ?>"
                                            <?php echo e($itinerary->day_number == $i ? 'selected' : ''); ?>><?php echo e($i); ?>

                                        </option>
                                    <?php endfor; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" id="title" class="form-control"
                                    value="<?php echo e($itinerary->title); ?>" required>
                                <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group">
                                <label for="map_url">Location</label>
                                <div id="map" style="height: 300px;"></div>
                                <input type="hidden" name="map_url" id="map_url" class="form-control"
                                    value="<?php echo e($itinerary->map_url); ?>">
                                <?php $__errorArgs = ['map_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group">
                                <label>Images</label>
                                <?php if(isset($itinerary->images) && $itinerary->images->isNotEmpty()): ?>
                                    <div class="row">
                                        <?php $__currentLoopData = $itinerary->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-md-4 mb-3">
                                                <div class="card">
                                                    <div class="card-body text-center">
                                                        <img src="<?php echo e(Storage::url($image->image_path)); ?>"
                                                            class="img-fluid mb-2" style="max-height: 150px;"
                                                            alt="<?php echo e($image->caption ?? 'Itinerary Image'); ?>">

                                                        
                                                        <div class="form-group">
                                                            <label
                                                                for="caption_existing_<?php echo e($image->id); ?>">Caption</label>
                                                            <input type="text"
                                                                name="existing_captions[<?php echo e($image->id); ?>]"
                                                                id="caption_existing_<?php echo e($image->id); ?>"
                                                                class="form-control" value="<?php echo e($image->caption); ?>">
                                                        </div>

                                                        
                                                        <div class="form-group mt-2">
                                                            <label for="replace_image_<?php echo e($image->id); ?>">Replace Image
                                                                (optional)</label>
                                                            <input type="file"
                                                                name="replace_images[<?php echo e($image->id); ?>]"
                                                                id="replace_image_<?php echo e($image->id); ?>"
                                                                class="form-control-file" accept="image/*">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php else: ?>
                                    <p class="text-muted">No images uploaded for this itinerary.</p>
                                <?php endif; ?>

                                
                                <div class="mt-3">
                                    <label>Add New Images (optional, up to 3 total)</label>
                                    <div class="row">
                                        <?php for($i = 0; $i < 3; $i++): ?>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="new_image_<?php echo e($i); ?>">New Image
                                                        <?php echo e($i + 1); ?></label>
                                                    <input type="file" name="new_images[]"
                                                        id="new_image_<?php echo e($i); ?>" class="form-control-file"
                                                        accept="image/*">
                                                </div>
                                                <div class="form-group">
                                                    <label for="new_caption_<?php echo e($i); ?>">Caption (optional)</label>
                                                    <input type="text" name="new_captions[]"
                                                        id="new_caption_<?php echo e($i); ?>" class="form-control">
                                                </div>
                                            </div>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">Update Itinerary</button>
                            <a href="<?php echo e(route('packages.itineraries', $package->id)); ?>"
                                class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>

    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />

    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <script>
        // Initialize map for editing itinerary
        (function() {
            // Try to parse server-side and pass a safe JSON string to JS to avoid quoting issues
            var safeCoords = <?php echo json_encode($itinerary->map_url ? json_decode($itinerary->map_url) : null, 15, 512) ?>;

            // Fallback coordinates if none provided (center of Sri Lanka)
            var defaultCoords = {
                lat: 7.8731,
                lng: 80.7718
            };
            var coords = safeCoords && safeCoords.lat && safeCoords.lng ? safeCoords : defaultCoords;

            var map = L.map('map').setView([coords.lat, coords.lng], 10);
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '© OpenStreetMap contributors'
            }).addTo(map);

            var marker = L.marker([coords.lat, coords.lng]).addTo(map);
            var coordinates = {
                lat: coords.lat,
                lng: coords.lng
            };

            map.on('click', function(e) {
                coordinates = e.latlng;
                marker.setLatLng(coordinates);
                document.getElementById('map_url').value = JSON.stringify(coordinates);
            });
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Savi Aby\Desktop\New folder (2)\Tharu_tours_asiri_savi\ceylon_tharu_tours\resources\views/admin/package_iteneries/edit_itinerary.blade.php ENDPATH**/ ?>