<?php $__env->startSection('title', 'CEYLON THARU TRAVELS | ALL REVIEWS'); ?>
<?php $__env->startSection('content_admin'); ?>

    <!-- Content Wrapper -->
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>All Reviews</h1>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="container-fluid">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Review Management</h3>
                    </div>
                    <div class="card-body">
                        <table id="reviewsTable" class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>User Name</th>
                                    <th>Ratings</th>
                                    <th>Comments</th>
                                    <th>Package</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($review->user_name); ?></td>
                                        <td>
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= $review->ratings): ?>
                                                    <i class="fas fa-star text-warning"></i>
                                                <?php else: ?>
                                                    <i class="far fa-star text-muted"></i>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </td>

                                        <td><?php echo e($review->comments); ?></td>
                                        <td><?php echo e($review->package ? $review->package->name : 'N/A'); ?></td>
                                        <td>
                                            <span
                                                class="badge
                                                <?php if($review->status == 'approved'): ?> badge-success
                                                <?php elseif($review->status == 'rejected'): ?> badge-danger
                                                <?php else: ?> badge-warning <?php endif; ?>">
                                                <?php echo e(ucfirst($review->status)); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <form action="<?php echo e(route('reviews.updateStatus', $review->id)); ?>" method="POST"
                                                style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PATCH'); ?>
                                                <select name="status" onchange="this.form.submit()"
                                                    class="form-control form-control-sm">
                                                    <option value="approved"
                                                        <?php echo e($review->status == 'approved' ? 'selected' : ''); ?>>Approved
                                                    </option>
                                                    <option value="rejected"
                                                        <?php echo e($review->status == 'rejected' ? 'selected' : ''); ?>>Rejected
                                                    </option>
                                                </select>
                                            </form>
                                            <form action="<?php echo e(route('reviews.destroy', $review->id)); ?>" method="POST"
                                                style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm"
                                                    onclick="return confirm('Are you sure you want to delete this review?')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- DataTables JS & CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>

    <script>
        $(document).ready(function() {
            $('#reviewsTable').DataTable({
                "pageLength": 10,
                "ordering": true,
                "lengthChange": true,
                "searching": true,
                "autoWidth": false,
                "responsive": true
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Savi Aby\Desktop\New folder (2)\Tharu_tours_asiri_savi\ceylon_tharu_tours\resources\views/admin/reviews_all.blade.php ENDPATH**/ ?>