



<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Booking Notification</title>
    <style>
        body {
            font-family: Arial, Helvetica, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f7f7f7;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        .header {
            background: linear-gradient(135deg, #4a6fa5, #2c3e50);
            color: white;
            padding: 25px 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }
        .header p {
            margin: 10px 0 0;
            opacity: 0.9;
            font-size: 16px;
        }
        .content {
            padding: 25px 30px;
        }
        .booking-info {
            background-color: #f9f9f9;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
        }
        .info-row {
            display: flex;
            margin-bottom: 12px;
            align-items: flex-start;
        }
        .info-label {
            font-weight: 600;
            min-width: 150px;
            color: #555;
        }
        .info-value {
            flex: 1;
            color: #333;
        }
        .notes-section {
            background-color: #f0f7ff;
            border-left: 4px solid #4a6fa5;
            padding: 15px;
            margin: 20px 0;
            border-radius: 0 4px 4px 0;
        }
        .cta-section {
            text-align: center;
            margin: 30px 0 20px;
        }
        .cta-button {
            display: inline-block;
            background: linear-gradient(135deg, #4a6fa5, #2c3e50);
            color: white;
            text-decoration: none;
            padding: 12px 25px;
            border-radius: 4px;
            font-weight: 600;
            margin: 0 10px 15px;
            transition: all 0.3s ease;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        .cta-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
        }
        .reply-button {
            background: linear-gradient(135deg, #28a745, #20c997);
        }
        .footer {
            text-align: center;
            padding: 20px;
            font-size: 12px;
            color: #777;
            border-top: 1px solid #eee;
            background-color: #f9f9f9;
        }
        .highlight {
            background-color: #fff9e6;
            padding: 15px;
            border-radius: 6px;
            margin: 20px 0;
            border-left: 4px solid #ffc107;
        }
        @media (max-width: 600px) {
            .container {
                margin: 10px;
            }
            .header, .content {
                padding: 20px;
            }
            .info-row {
                flex-direction: column;
                margin-bottom: 15px;
            }
            .info-label {
                min-width: auto;
                margin-bottom: 5px;
            }
            .cta-button {
                display: block;
                margin: 0 0 15px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>New Booking Inquiry Received</h1>
            <p>You have a new booking request that requires your attention</p>
        </div>

        <div class="content">
            <div class="highlight">
                <p><strong>Action Required:</strong> Please review this booking request and take appropriate action.</p>
            </div>

            <div class="booking-info">
                <div class="info-row">
                    <div class="info-label">Package:</div>
                    <div class="info-value"><?php echo e($booking->package->title ?? 'N/A'); ?></div>
                </div>
                <div class="info-row">
                    <div class="info-label">Customer Name:</div>
                    <div class="info-value"><?php echo e($booking->name ?? $booking->user_name ?? 'N/A'); ?></div>
                </div>
                <div class="info-row">
                    <div class="info-label">Email:</div>
                    <div class="info-value"><?php echo e($booking->email ?? 'N/A'); ?></div>
                </div>
                <div class="info-row">
                    <div class="info-label">Mobile:</div>
                    <div class="info-value"><?php echo e($booking->mobile ?? 'N/A'); ?></div>
                </div>
                <div class="info-row">
                    <div class="info-label">Country:</div>
                    <div class="info-value"><?php echo e($booking->country ?? 'N/A'); ?></div>
                </div>
                <div class="info-row">
                    <div class="info-label">Number of People:</div>
                    <div class="info-value"><?php echo e($booking->num_people ?? '-'); ?></div>
                </div>
                <div class="info-row">
                    <div class="info-label">Expected Date:</div>
                    <div class="info-value"><?php echo e($booking->expected_date ?? '-'); ?></div>
                </div>
            </div>

            <div class="notes-section">
                <p><strong>Special Requests / Notes:</strong></p>
                <p><?php echo e($booking->notes ?? $booking->special_req ?? 'None provided'); ?></p>
            </div>

            <div class="cta-section">
                <a href="mailto:<?php echo e($booking->email ?? '#'); ?>?subject=Re: Booking Inquiry - <?php echo e($booking->package->title ?? 'Package'); ?>" class="cta-button reply-button">Reply to Customer</a>
            </div>

            <p style="text-align: center; color: #666; margin-top: 20px;">
                You can also view this booking in the admin panel.
            </p>
        </div>

        <div class="footer">
            <p>This is an automated message. Please do not reply to this email.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\Users\Savi Aby\Desktop\New folder (2)\Tharu_tours_asiri_savi\ceylon_tharu_tours\resources\views/emails/booking-received.blade.php ENDPATH**/ ?>